﻿$(function () {
	$('#userGroup').combotree({
		multiple : false,
		checkbox : false,
		lines : true,
		animate : true,
		editable : false,
		url : baseUrl + '/admin/U030/findGroupAddALL.html',
		required : false,
		onSelect: function(rec){
			var courseId = $('#groupCourse').combobox('getValue');
			showData(rec.id,courseId);
			$("#gourpHidden").val(rec.id);
			$('#itemlist').datagrid('load', {
				groupPid : rec.id,
				courseId : courseId
			});
		}
	});
	$('#groupCourse').combobox({
		url :baseUrl + '/admin/S070/listCourseNameAll.html',
		editable : false,
		required : false,
		panelMinWidth:200,
		panelMaxWidth:300,
		panelMaxHeight:200,
		valueField : 'courseId',
		textField : 'courseName',
		onSelect: function(rec){
			var groupPid = $('#userGroup').combotree('getValue');
			showData(groupPid,rec.courseId);
			$('#itemlist').datagrid('load', {
				groupPid : groupPid,
				courseId : rec.courseId
			});
        }
	});

	showData(0,0);
	creatGrid();
});

/**
 * easyUi dataGrid注册方式说明，防止二次渲染 class注册方式一般是为了初始化属性，js方式则属性和事件都可初始化
 * 但是不管是class方式还是js方式注册组件，每次注册，只要被设置过url属性就会做请求。
 * 所以在不可避免要使用js方式注册的情况下，索性就不要使用class方式注册了。
 */
function creatGrid() {
	$('#itemlist').datagrid({
		fit : true,// 设置为true时铺满它所在的容器.
		fitColumns : true,// 设置为true将自动使列适应表格宽度以防止出现水平滚动
		nowrap : false,// 设置为true，当数据长度超出列宽时将会自动截取。
		striped : true,// 设置为true将交替显示行背景。
		idField : 'name', // 是标识字段
		collapsible : true,// 定义是否显示可折叠按钮。
		singleSelect : false,// 设置为true将只允许选择一行。
		border : false,
		remoteSort : false,// 定义是否通过远程服务器对数据排序。
		pagination : false,// 分页组件是否显示
		pageNumber : 1,// 起始页
		pageSize : 10,// 每页显示的记录条数，默认为10
		pageList : [ 10, 20, 50, 100 ],// 每页显示多少行
		rownumbers : true,// 行号
		queryParams : {'groupPid': $('#userGroup').combotree('getValue'), 'courseId': $('#groupCourse').combobox('getValue')},
		url : baseUrl + '/admin/S070/listCourseData.html',
		columns : [ [ {
			field : 'name',
			title : '机构名称',
			width : 100,
			sortable : true,
			halign: 'center',
			align : 'left'
		}, {
			field : 'xxcnt',
			title : '应学习人数',
			width : 80,
			sortable : true,
			halign: 'center',
			align : 'right'
		}, {
			field : 'wxxcnt',
			title : '未学习人数',
			width : 80,
			sortable : true,
			halign: 'center',
			align : 'right'
		}, {
			field : 'xxzcnt',
			title : '学习中人数',
			width : 80,
			sortable : true,
			halign: 'center',
			align : 'right'
		}, {
			field : 'yxwcnt',
			title : '已学完人数',
			width : 80,
			sortable : true,
			halign: 'center',
			align : 'right'
		}, {
			field : 'tgcnt',
			title : '已通过人数',
			width : 80,
			sortable : true,
			halign: 'center',
			align : 'right'
		}, {
			field : 'tgl',
			title : '课程的通过率',
			width : 80,
			sortable : true,
			halign: 'center',
			align : 'right',
			formatter : fmTgl
		} ] ],
		// 当数据载入成功时触发。
		onLoadSuccess : function(data) {

		}
	});
}

// 显示
function showData(groupPid,courseId) {
	$.post(baseUrl + "/admin/S070/listCourseData.html", {
		groupPid : groupPid,
		courseId : courseId
	}, function(data) {
		var obj = eval("(" + data + ")");//json为接收的后台返回的数据
		
		var json = obj.rows;
		var arr = new Array();
		var pieArr = new Array();
		var jgArr = new Array();
		for(var i=0;i<json.length;i++){
			var str = "{type: 'column', name: '" + json[i].name +
	            "',data:[" + json[i].xxcnt + "," 
	            + json[i].wxxcnt + ","
	            + json[i].xxzcnt + ","
	            + json[i].yxwcnt + ","
	            + json[i].tgcnt + ","
	            + (json[i].tgcnt / json[i].xxcnt).toFixed(4) * 100 + ","
	            + "]}";
			arr.push(str);
			
			var pieStr = "{name: '" + json[i].name +"', y: "+ json[i].xxcnt + ",color: Highcharts.getOptions().colors[" + i +"]}";
			pieArr.push(pieStr);
			
		}
		
//		var str = "{type: 'spline',name: '及格率',data:[" + jgArr.join(",") + 
//            "],marker: {lineWidth: 2,lineColor: Highcharts.getOptions().colors[3],fillColor: 'white'}}";
//		arr.push(str);
		
		var str = "{type: 'pie', name: '机构人员统计',data: [" + pieArr.join(",") + "],"+
            "center: [100, 80],"+
            "size: 100,"+
            "showInLegend: false,"+
            "dataLabels: {"+
                "enabled: false"+
            "}"+
        "}";
		arr.push(str);
		var jsonString="["+arr.join(",")+"]";
		var jsonArr = eval('(' + jsonString + ')');
		
	    $('#container').highcharts({
	        title: {
	            text: '机构课程统计'
	        },
	        xAxis: {
	            categories: ['应学习人数','未学习人数','学习中人数','已学完人数','已通过人数','课程的通过率']
	        },
	        labels: {
	            items: [{
	                html: '机构用户数统计',
	                style: {
	                    left: '70px',
	                    top: '18px',
	                    color: (Highcharts.theme && Highcharts.theme.textColor) || 'black'
	                }
	            }]
	        },
	        series: jsonArr
	    });
	});
}
//课程通过率
function fmTgl(value, rowData, rowIndex) {
	if (rowData.xxcnt == 0) {
		return 0;
	} else {
		return (rowData.tgcnt / rowData.xxcnt).toFixed(2);
	}
}